#include <epp.h>

// epp_Frame is the base class for a window with message
// handling. To handle messages in non-default manner, you
// must derive a class from epp_Frame

class MyFrame : public epp_Frame
{
    private:

        // these functions correspond to Windows messages
        // and must be present if the message is trapped in
        // the BEGIN_HANDLER block later. The functions
        // must be declared as they are in handler.epp
        int OnCreate (CREATESTRUCT *);
        void OnPaint ();
        void OnSize (int, int, int);

        // some private data
        epp_Font font;

    // this adds some necessary message
    // handling code to the class
    DECLARE_HANDLER
};

// this function is called when the window is
// created (WM_CREATE message)
int MyFrame::OnCreate (CREATESTRUCT *)
{
    font.Create (48, "Arial");
    return 0;
}

// this function called when the window needs to
// be drawn (WM_PAINT message)
void MyFrame::OnPaint ()
{
    // a "context" is a Windows thing through which
    // all drawing is done.  an epp_PaintContext object
    // is a context only used within OnPaint
    epp_PaintContext dc;
    RECT rect;

    GetClientRect (&rect);

    dc.BeginPaint (*this);
    dc.SelectObject (font);
    dc.DrawText ("Hello World", -1, &rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
}

// this function is called when the window is
// resized (WM_SIZE message)
void MyFrame::OnSize (int, int, int)
{
    InvalidateRect ();
}

// This is the actual message handling code. each line between
// the BEGIN_HANDLER and END_HANDLER specifies a windows message
// to be trapped.  These lines are in the form ON_XXXXX, where
// XXXXX is the name of the winows message. Each message that's
// trapped calls a particular function defined in handler.epp.
// Messages that are not trapped are passed to the parent class
// (in this case, epp_Frame). Arguments for BEGIN_HANDLER are the
// child and parent classes respectively.

BEGIN_HANDLER (MyFrame, epp_Frame)
    ON_WM_PAINT
    ON_WM_SIZE
    ON_WM_CREATE
END_HANDLER

// this is the "main" function. The standard Windows entry point
// is WinMain. The epp library defines WinMain and calls epp_Main

int epp_Main ()
{
    // create the window
    MyFrame frame;
    frame.Create ("EPP Demo");
    frame.ShowWindow (SW_NORMAL);
    frame.UpdateWindow ();

    // this creates the message loop, which will automatically
    // terminate when it detects a WM_QUIT. A WM_QUIT will be
    // posted by the epp library when the last window (in this
    // case, the only window) is closed
    epp_App app;
    app.Run ();

    return 0;
}