///////////////////
// Animate Class //
///////////////////

#include "epp.epp"
#include "main.epp"
#include "resource.epp"
#include "window.epp"
#include "class.epp"
#include "signal.epp"
#include "mutex.epp"
#include "router.epp"
#include "handler.epp"
#include "frame.epp"
#include "timer.epp"
#include "object.epp"
#include "bitmap.epp"
#include "brush.epp"
#include "context.epp"
#include "animate.epp"

HWND epp_Animate::Create (int filmid, int maskid, COLORREF back, int frames, int timer, DWORD style, RECT& rect, HWND parent)
{
    epp_WindowContext temp;
    epp_CustomContext work;
    epp_CustomContext film;
    epp_Bitmap filmbitmap;
    epp_Bitmap maskbitmap;
    epp_Bitmap notbitmap;
    epp_Brush brush;
    RECT trect;

    _Frames = frames;
    _Frame = 0;
    _Ticker = timer;
    _Width = rect.right - rect.left;
    _Height = rect.bottom - rect.top;

    temp.GetDC (parent);
    _Source.CreateCompatibleDC (temp);
    _Bitmap.CreateCompatibleBitmap (temp, _Width * _Frames, _Height);
    work.CreateCompatibleDC (temp);
    film.CreateCompatibleDC (temp);
    temp.Close ();

    filmbitmap.LoadBitmap (filmid);
    maskbitmap.LoadBitmap (maskid);
    brush.CreateSolidBrush (back);

    _Source.SelectObject (_Bitmap);
    film.SelectObject (filmbitmap);

    trect.left = 0;
    trect.top = 0;
    trect.right = (_Width * _Frames) + 1;
    trect.bottom = _Height + 1;
    _Source.FillRect (&trect, brush);
    work.SelectObject (maskbitmap);
    _Source.BitBlt (0, 0, _Width * _Frames, _Height, work, 0, 0, SRCAND);
    work.BitBlt (0, 0, _Width * _Frames, _Height, work, 0, 0, NOTSRCCOPY);
    work.BitBlt (0, 0, _Width * _Frames, _Height, film, 0, 0, SRCAND);
    _Source.BitBlt (0, 0, _Width * _Frames, _Height, work, 0, 0, SRCPAINT);

    return epp_Frame::Create (0, NULL, style | WS_CHILD, rect, parent);
}