//////////////////
// Router Class //
//////////////////

#include "epp.epp"
#include "main.epp"
#include "resource.epp"
#include "window.epp"
#include "signal.epp"
#include "mutex.epp"
#include "router.epp"

static LRESULT APIENTRY _Router (HWND win, UINT msg, WPARAM wparam, LPARAM lparam)
  {
  epp_Window *epp_win;
  UINT msg_save;
  WPARAM wparam_save;
  LPARAM lparam_save;
  LRESULT result;

  epp_win = EPP_ROUTER.Lookup (win);

  if (!epp_win)
    {
    epp_win = EPP_ROUTER.Attach (win);
    epp_win->Attach (win);
    EPP_ROUTER.Finish ();
    }

  epp_win->Get (msg_save, wparam_save, lparam_save);
  epp_win->Set (msg, wparam, lparam);
  result = epp_win->Message ();
  epp_win->Set (msg_save, wparam_save, lparam_save);

  if (msg == WM_NCDESTROY)
    {
    EPP_ROUTER.Detach (win);
    epp_win->Attach (NULL);
    }

  return result;
  }

epp_Router::epp_Router () : LINKS (100)
  {
  int i;

  _Top = 0;
  _Last = 0;
  _Links = new _Link [LINKS];

  for (i = 0; i < LINKS; i++)
    _Links [i].handle = NULL;

  _Mutex.Create (FALSE);
  }

epp_Router::~epp_Router ()
  {
  delete _Links;
  }

void epp_Router::Connect (epp_Window *win)
  {
  _Mutex.Wait ();
  _Window = win;
  }

void epp_Router::Finish ()
  {
  _Window = NULL;
  _Mutex.Release ();
  }

epp_Window * epp_Router::Lookup (HWND win)
  {
  int index;

  index = _Find (win);
  return (index < 0)? NULL : _Links [index].window;
  }

epp_Window * epp_Router::Attach (HWND win)
  {
  int index;

  index = 0;

  while (_Links [index].handle)
    index ++;

  _Links [index].handle = win;
  _Links [index].window = _Window;
  _Last = index;

  index ++;
  if (index > _Top)
    _Top = index;

  return _Window;
  }

void epp_Router::Replace (HWND hwnd)
  {
  _Links [_Find (hwnd)].window = _Window;
  }

void epp_Router::Detach (HWND win)
  {
  int index = _Find (win);

  if (index != -1)
    _Links [index].handle = NULL;
  }

epp_Router::operator WNDPROC ()
  {
  return _Router;
  }

int epp_Router::_Find (HWND win)
  {
  if (_Links [_Last].handle == win)
    return _Last;

  int count = _Top;

  if (count)
    do {
      count --;
      _Last = (_Last + 1) % _Top;
    } while (count && (_Links [_Last].handle != win));

  return (count)? _Last : -1;
  }

epp_Router EPP_ROUTER;