////////////////////
// Subclass Class //
////////////////////

#include "epp.epp"
#include "main.epp"
#include "resource.epp"
#include "window.epp"
#include "signal.epp"
#include "mutex.epp"
#include "router.epp"
#include "subclass.epp"

epp_Subclass::~epp_Subclass ()
{
    Close ();
}

void epp_Subclass::Create (HWND window, int index)
{
    Close ();

    _Destroy = TRUE;
    _Subclass = EPP_ROUTER.Lookup (window);

    Attach (window);
    EPP_ROUTER.Connect (this);

    if (_Subclass)
        EPP_ROUTER.Replace (window);
    else {
        EPP_ROUTER.Attach (window);
        _Index = index;
        _Chain = (WNDPROC) SetWindowLong (index, (LONG) (WNDPROC) EPP_ROUTER);
    }

    EPP_ROUTER.Finish ();
}

void epp_Subclass::Destroy ()
{
    if (_Subclass) {
        EPP_ROUTER.Connect (_Subclass);
        EPP_ROUTER.Replace (_Handle);
        EPP_ROUTER.Finish ();
    } else {
        SetWindowLong (_Index, (LONG) _Chain);
        EPP_ROUTER.Detach (_Handle);
    }
    _Handle = NULL;
}

LRESULT epp_Subclass::System ()
{
    UINT msg_save;
    WPARAM wparam_save;
    LPARAM lparam_save;
    LRESULT result;

    if (_Subclass) {
        _Subclass->Get (msg_save, wparam_save, lparam_save);
        _Subclass->Set (_Message, _wParam, _lParam);
        result = _Subclass->Message ();
        _Subclass->Set (msg_save, wparam_save, lparam_save);
    } else
        result = CallWindowProc (_Chain, _Handle, _Message, _wParam, _lParam);

    return result;
}