///////////////////
// Toolbar Class //
///////////////////

#include "epp.epp"
#include "main.epp"
#include "resource.epp"
#include "window.epp"
#include "toolbar.epp"

HWND epp_ToolBar::Create (HWND owner, DWORD style, UINT id, const int *commands, int count)
{
	TBBUTTON *data;
	int bitmap;
	HWND ret;

	data = new TBBUTTON [count];
	memset (data, 0, count * sizeof (TBBUTTON));

	bitmap = 0;

	for (int i = 0; i < count; i++) {
		data [i].idCommand = commands [i];
		data [i].fsState = TBSTATE_ENABLED;
		if (commands [i]) {
			data [i].iBitmap = bitmap;
			data [i].fsStyle = TBSTYLE_BUTTON;
			bitmap ++;
		} else {
			data [i].iBitmap = 0;
			data [i].fsStyle = TBSTYLE_SEP;
		}
	}

	ret = CreateToolbarEx (owner, style | WS_CHILD, 0, count, EPP_INSTANCE, id, data, count, 0, 0, 0, 0, sizeof (TBBUTTON));
	delete data;
	return ret;
}